/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.primitive;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import de.hysky.skyblocker.compatibility.CaxtonCompatibility;
import de.hysky.skyblocker.utils.render.Renderer;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveRenderer;
import de.hysky.skyblocker.utils.render.state.TextRenderState;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11767;
import net.minecraft.class_12075;
import net.minecraft.class_12137;
import net.minecraft.class_287;
import net.minecraft.class_327;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public final class TextPrimitiveRenderer
implements PrimitiveRenderer<TextRenderState> {
    protected static final TextPrimitiveRenderer INSTANCE = new TextPrimitiveRenderer();
    private static final @Nullable RenderPipeline CAXTON_SEE_THROUGH = CaxtonCompatibility.getSeeThroughTextPipeline().orElse(null);
    private static final @Nullable RenderPipeline CAXTON_NORMAL = CaxtonCompatibility.getTextPipeline().orElse(null);

    private static RenderPipeline getPipeline(boolean seeThrough, boolean intensity) {
        if (seeThrough) {
            return CAXTON_SEE_THROUGH != null ? CAXTON_SEE_THROUGH : (intensity ? class_10799.field_56824 : class_10799.field_56822);
        }
        return CAXTON_NORMAL != null ? CAXTON_NORMAL : (intensity ? class_10799.field_56820 : class_10799.field_56818);
    }

    private TextPrimitiveRenderer() {
    }

    @Override
    public void submitPrimitives(final TextRenderState state, class_12075 cameraState) {
        final Matrix4f positionMatrix = new Matrix4f().translate((float)(state.pos.method_10216() - cameraState.field_63078.method_10216()), (float)(state.pos.method_10214() - cameraState.field_63078.method_10214()), (float)(state.pos.method_10215() - cameraState.field_63078.method_10215())).rotate((Quaternionfc)cameraState.field_63081).scale(state.scale, -state.scale, state.scale);
        state.glyphs.method_71801(new class_327.class_11464(){

            public void method_71797(class_11767.class_12238 glyph) {
                this.draw((class_11767)glyph);
            }

            public void method_71798(class_11767 bakedGlyph) {
                this.draw(bakedGlyph);
            }

            private void draw(class_11767 glyph) {
                class_11231 textureSetup = class_11231.method_70902((GpuTextureView)glyph.comp_4629(), (class_12137)RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST));
                class_287 buffer = Renderer.getBuffer(TextPrimitiveRenderer.getPipeline(state.throughWalls, glyph.method_73400() == class_10799.field_61742), textureSetup);
                glyph.method_73403(positionMatrix, (class_4588)buffer, 0xF000F0, false);
            }
        });
    }
}

