/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.waypoint;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class OrderedNamedWaypoint
extends NamedWaypoint {
    private static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
    private static final float[] WHITE_COLOR_COMPONENTS = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    private static final float[] FLOAT_ARRAY = new float[4];
    int index;
    RelativeIndex relativeIndex = RelativeIndex.NONE;

    public OrderedNamedWaypoint(NamedWaypoint namedWaypoint) {
        this(namedWaypoint.pos, namedWaypoint.name, namedWaypoint.typeSupplier, namedWaypoint.colorComponents, namedWaypoint.alpha, namedWaypoint.isEnabled(), namedWaypoint.throughWalls);
    }

    public OrderedNamedWaypoint(class_2338 pos, String name, float[] colorComponents) {
        this(pos, class_2561.method_30163((String)name), () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType, colorComponents, 0.5f, true);
    }

    public OrderedNamedWaypoint(class_2338 pos, class_2561 name, Supplier<Waypoint.Type> typeSupplier, float[] colorComponents, float alpha, boolean shouldRender) {
        this(pos, name, typeSupplier, colorComponents, alpha, shouldRender, true);
    }

    public OrderedNamedWaypoint(class_2338 pos, class_2561 name, Supplier<Waypoint.Type> typeSupplier, float[] colorComponents, float alpha, boolean shouldRender, boolean throughWalls) {
        super(pos, name, typeSupplier, colorComponents, alpha, shouldRender, throughWalls);
    }

    @Override
    public OrderedNamedWaypoint copy() {
        return new OrderedNamedWaypoint(this);
    }

    @Override
    public OrderedNamedWaypoint withX(int x) {
        return new OrderedNamedWaypoint(new class_2338(x, this.pos.method_10264(), this.pos.method_10260()), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withY(int y) {
        return new OrderedNamedWaypoint(new class_2338(this.pos.method_10263(), y, this.pos.method_10260()), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withZ(int z) {
        return new OrderedNamedWaypoint(new class_2338(this.pos.method_10263(), this.pos.method_10264(), z), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withColor(float[] colorComponents, float alpha) {
        return new OrderedNamedWaypoint(this.pos, this.name, this.typeSupplier, colorComponents, alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withThroughWalls(boolean throughWalls) {
        return new OrderedNamedWaypoint(this.pos, this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withTypeSupplier(Supplier<Waypoint.Type> typeSupplier) {
        return new OrderedNamedWaypoint(this.pos, this.name, typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public OrderedNamedWaypoint withName(String name) {
        return new OrderedNamedWaypoint(this.pos, class_2561.method_30163((String)name), this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled());
    }

    @Override
    public boolean shouldRender() {
        return super.shouldRender() && this.relativeIndex.shouldRender();
    }

    @Override
    public float[] getRenderColorComponents() {
        return switch (this.relativeIndex.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> super.getRenderColorComponents();
            case 1 -> RED_COLOR_COMPONENTS;
            case 2 -> WHITE_COLOR_COMPONENTS;
            case 3 -> GREEN_COLOR_COMPONENTS;
        };
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        super.extractRendering(collector);
        UIAndVisualsConfig.Waypoints waypoints = SkyblockerConfigManager.get().uiAndVisuals.waypoints;
        if (waypoints.renderLine && this.relativeIndex == RelativeIndex.NEXT && this.shouldRender()) {
            float[] components = waypoints.lineColor.getComponents(FLOAT_ARRAY);
            collector.submitLineFromCursor(this.centerPos, components, components[3], waypoints.lineWidth);
        }
        if (this.shouldRenderName()) {
            float scale = Math.max((float)RenderHelper.getCamera().method_71156().method_1022(this.centerPos) / 10.0f, 1.0f);
            class_2561 class_25612 = class_2561.method_30163((String)String.valueOf(this.index + 1));
            class_243 class_2432 = this.centerPos.method_1031(0.0, 1.0, 0.0);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            collector.submitText(class_25612, class_2432, scale, 9 + 1, true);
        }
    }

    public static enum RelativeIndex {
        NONE,
        PREVIOUS,
        CURRENT,
        NEXT;


        public boolean shouldRender() {
            return this != NONE;
        }
    }
}

