/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.ws.message;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.skyblock.dwarven.CrystalsLocationsManager;
import de.hysky.skyblocker.skyblock.dwarven.MiningLocationLabel;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.ws.Type;
import de.hysky.skyblocker.utils.ws.message.Message;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;

public record CrystalsWaypointMessage(MiningLocationLabel.CrystalHollowsLocationsCategory location, class_2338 coordinates) implements Message<CrystalsWaypointMessage>
{
    private static final Codec<CrystalsWaypointMessage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiningLocationLabel.CrystalHollowsLocationsCategory.CODEC.fieldOf("name").forGetter(CrystalsWaypointMessage::location), (App)class_2338.field_25064.fieldOf("coordinates").forGetter(CrystalsWaypointMessage::coordinates)).apply((Applicative)instance, CrystalsWaypointMessage::new));
    private static final Codec<List<CrystalsWaypointMessage>> LIST_CODEC = CODEC.listOf();

    public static void handle(Type type, Optional<Dynamic<?>> message) {
        switch (type) {
            case RESPONSE: {
                if (message.isEmpty()) {
                    return;
                }
                CrystalsWaypointMessage waypoint = (CrystalsWaypointMessage)CODEC.parse(message.get()).getOrThrow();
                RenderHelper.runOnRenderThread(() -> CrystalsLocationsManager.addCustomWaypointFromSocket(waypoint));
                break;
            }
            case INITIAL_MESSAGE: {
                if (message.isEmpty()) {
                    return;
                }
                List waypoints = (List)LIST_CODEC.parse(message.get()).getPartialOrThrow();
                if (waypoints.isEmpty()) {
                    return;
                }
                RenderHelper.runOnRenderThread(() -> CrystalsLocationsManager.addCustomWaypointFromSocket(waypoints.toArray(new CrystalsWaypointMessage[0])));
                break;
            }
        }
    }

    @Override
    public Codec<CrystalsWaypointMessage> getCodec() {
        return CODEC;
    }
}

